# 20.0.0 - Glossary (index)

> Canonical concept definitions with dual-register mapping and recursive examples.

---

## Module Overview

The Glossary provides stable definitions for all derived concepts in Delta Theory:
- Maintains both technical precision and humane understanding
- Shows recursive manifestations across scales
- Supports formal expression and implementation
- Bridges between registers and domains

Note: Core primitives are defined in [[00.0.0 - Virtual Substrate — Kernel Primitives (index)]].

---

## Content Structure

| Category | Description | Key Elements |
|----------|-------------|--------------|
| Core Polarities | Primary aspects | [[Structure]] (P+), [[Void]] (P-), [[Awareness]] (P0) |
| Recursive Concepts | Scale-aware terms | [[Field]], [[Form]], [[Relation]], [[Memory]] |
| Boundary Cases | Edge conditions | [[Zero]], [[Infinite]], [[Fixed Point]], [[Recurrence Interval]] |
| Diagnostic Terms | Observable properties | [[Stability]], [[Coherence]], [[Resolution]], [[Phase]] |

Each term provides:
- Technical and humane definitions
- Scale manifestations
- Domain examples
- Usage guidance

---

## Implementation Notes

### Term Categories

1. **Core Polarities**
   - Structure (form-making)
   - Void (field/environment)
   - Awareness (cognitive/time)

2. **Recursive Concepts**
   - Scale-aware definitions
   - Cross-domain examples
   - Bridge mappings

3. **Boundary Cases**
   - Edge conditions
   - Limit behaviors
   - Special handling

4. **Diagnostic Terms**
   - Observable properties
   - Measurable aspects
   - Test conditions

### Templates

Use these templates for new entries:
- [[glossary]] - Base template for most terms
- [[glossary-diagnostic]] - For diagnostic/property terms

---

## See Also

- [[00.0.0 - Virtual Substrate — Kernel Primitives (index)]] - For primitives
- [[20.0 - Symbolic Structure (meta)]]
- [[tags]]
- [[PRINCIPLES]]